DROP PROCEDURE [hips].[ContactMethodInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 15 Oct 2012
-- Description:   Gets a specific record from the Country Table
-- =============================================
CREATE PROCEDURE [hips].[ContactMethodInsert] 
(
	@TelecommunicationType VARCHAR(10),
	@CdaType VARCHAR(10),
	@Description varchar(40),
	@UserModified varchar(256)
)
AS
BEGIN
	SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @ContactMethodId int

    SET @intErrorCode = 0

	INSERT INTO hips.ContactMethod
	        ( TelecommunicationType ,
	          CdaType ,
	          Description,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  (	@TelecommunicationType,
				@CdaType,
				@Description,
				GETDATE(),
				@UserModified,
				GETDATE(),
				@UserModified
	
	        )
	SELECT @intErrorCode = @@ERROR , @ContactMethodId = SCOPE_IdENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [ContactMethodId],
                TelecommunicationType,
                CdaType,
                Description,
                [DateCreated],
                [UserCreated],
                [DateModified],
                [UserModified]
         FROM [hips].[ContactMethod]
         WHERE [ContactMethodId] = @ContactMethodId
    END

    RETURN(@intErrorCode)


END
GO

